// To parse this JSON data, do
//
//     final allRequestResponseModel = allRequestResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:play_lab/data/model/global/global_meassage.dart';
import 'package:play_lab/data/model/request/request_model.dart';

AllRequestResponseModel allRequestResponseModelFromJson(String str) => AllRequestResponseModel.fromJson(json.decode(str));

String allRequestResponseModelToJson(AllRequestResponseModel data) => json.encode(data.toJson());

class AllRequestResponseModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  AllRequestResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory AllRequestResponseModel.fromJson(Map<String, dynamic> json) => AllRequestResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  List<RequestItem>? items;
  String? imagePath;
  Pagination? pagination;

  Data({
    this.items,
    this.imagePath,
    this.pagination,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        items: json["items"] == null ? [] : List<RequestItem>.from(json["items"]!.map((x) => RequestItem.fromJson(x))),
        imagePath: json["image_path"],
        pagination: json["pagination"] == null ? null : Pagination.fromJson(json["pagination"]),
      );

  Map<String, dynamic> toJson() => {
        "items": items == null ? [] : List<dynamic>.from(items!.map((x) => x.toJson())),
        "image_path": imagePath,
        "pagination": pagination?.toJson(),
      };
}

class Pagination {
  String? nextPageUrl;

  Pagination({
    this.nextPageUrl,
  });

  factory Pagination.fromJson(Map<String, dynamic> json) => Pagination(
        nextPageUrl: json["next_page_url"],
      );

  Map<String, dynamic> toJson() => {
        "next_page_url": nextPageUrl,
      };
}
